/*
Program : Strip (Secure Tool for Recalling Important Passwords) 
Description: A secure password and account manager for the Palm(t) Computing Platform 
Copyright (C) 1999  Stephen J Lombardo

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Strip has been written and developed by Stephen J Lombardo (Zetetic Enterprises) 1999

Contact Info:
lombardos@zetetic.net
http://www.zetetic.net/
Zetetic Enterprises
348 Wasington Ave 
Clifton NJ, 07011

Bug reports and feature requests should be sent to bugs@zetetic.net.


------RSA Data Security, Inc. MD5 Message Digest Algorithm-------------
Strip uses the MD5 message digest algorithm, Copyright (C) 1990, 
RSA Data Security, Inc. All rights reserved. See md5.c or md5.h 
for specific terms and warranty disclaimer from RSA Data Security Inc.
-----------------------------------------------------------------------

------Three-way block encryption---------------------------------------
Strip uses the 3-Way block encryption algoritm, Copyright (C) Joan 
Daemen. All rights reserved.
-----------------------------------------------------------------------

------Idea block encryption---------------------------------------
Strip uses the Idea block encryption algoritm, Copyright (C) Ascom. All rights reserved.
Idea is a patented algorithm. It is free for non commercial use, if you wish to use 
this product or the Idea algorithm in general for commercial purposes, you must purchase a license
from Ascom at http://www.ascom.ch/infosec/idea/pricing.html
-----------------------------------------------------------------------
 
        <**  DO NOT EXPORT **>
Strip uses strong cryptography. "3-way" is a block algoritm with a
96 bit key length, and "MD5" creates a 128 bit message digest. In the 
United states it is currently illegal to export products describing
or incorporating encryption techniques with key lengths greater
than 40 bits. It is therefore illegal to export this program in
any format. Please dont get the government on my back...
*/

#include <Pilot.h>    
#include "StripFixRsc.h"
#include "StripFix.h"

#ifdef __GNUC__
#include "Callbacks.h"
#endif      


/* Global Variables */
Word currentForm, oldForm;
static DmOpenRef SystemDB, AccountDB, PasswordDB;
Boolean firstRun=false, passwordEchoOff=false, hideSecretRecords;
char * SysPass;
Boolean oldtonew=true, newtoold=false;




/************************************************************************
 * Function: GetObjectFromActiveForm
 * Description: pass this function the object id of any UI object in the 
 * currently active form and it will return a valid pointer to the 
 * UI object.
 * *********************************************************************/
static VoidPtr GetObjectFromActiveForm(Word objectID)
{
    FormPtr curForm=FrmGetActiveForm();
    return FrmGetObjectPtr(curForm, FrmGetObjectIndex(curForm, objectID));
}


/************************************************************************
 * Function: setFieldFromHandle
 * Description:  Pass the function the object id of a field and a handle
 * containing the text and it sets the field value to the text handle.
 * It will return a pointer to the set field.
 * **********************************************************************/
static FieldPtr setFieldFromHandle(Word field, VoidHand text)
{
    VoidHand oldText;
    FieldPtr fld;
    
    fld=GetObjectFromActiveForm(field);

        // get a pointer to the old handle
    oldText=(VoidHand)FldGetTextHandle(fld);
    FldSetTextHandle(fld, (Handle)text);
    FldDrawField(fld);

        // deallocate the old handle 
    if(oldText)
        MemHandleFree(oldText);
    
    return fld;
}

/************************************************************************
 * Function: setFieldFromString
 * Description:  Pass the function the object id of a field and a string
 * containing the text and it creates a new handle, and calls setField from
 * handle to set the field value. 
 * It will return a pointer to the set field.
 * **********************************************************************/
static FieldPtr setFieldFromString(Word field, CharPtr str)
{
    VoidHand text;

    text=MemHandleNew(StrLen(str)+1);
    if(!text)
        return NULL;

        // copy the string to the new handle
    StrCopy(MemHandleLock(text), str);
    MemHandleUnlock(text);
    return setFieldFromHandle(field, text);
}


/**********************************************************************
 * Function: getDatabase
 * Description: pass the function the necessare database information,
 * and it will either open an existing database or create a new one if 
 * neccessary. "created" will be true if a new database was created
 * *******************************************************************/
static Err getDatabase(DmOpenRef *DBptr, ULong type, ULong creator, ULong mode, UInt card, char *name, Boolean *created)
{
    Err errors;
    *created=false;
    *DBptr=DmOpenDatabaseByTypeCreator(type, creator, mode);
    errors = DmGetLastErr();
        
        // if the database does not exist, make a new one.
    if(! *DBptr)
    {
        errors=DmCreateDatabase(0, name, creator, type, false);
        if (errors)
            return errors;
        *created=true;
        *DBptr=DmOpenDatabaseByTypeCreator(type, creator, mode);
        if( ! *DBptr)
            return DmGetLastErr();
    }
}

/********************************************************************
 * Function: addSystem
 * Description:  function responsible for writing a packed System record
 * to the database. 
 * ******************************************************************/
static void addSystem(RecordBuffer sys, VoidHand systemDBrec)
{
    UInt length=0;
    CharPtr ch;
    UInt offset=0;

        // get length of the system buffer
    length=MemPtrSize(sys);
        
        // re-size and write.
    if(MemHandleResize(systemDBrec, length)==0)
    {
        ch=MemHandleLock(systemDBrec);
        DmWrite(ch, offset, sys, length);
        MemHandleUnlock(systemDBrec);
    }
    else
        FrmAlert(GenericError);
        
}

/********************************************************************
 * Function: addPassword
 * Description:  function responsible for writing a packed password record
 * to the database. 
 * ******************************************************************/
static void addPassword(RecordBuffer pass, VoidHand pwDBrec)
{
    UInt length=0;
    CharPtr ch;
    UInt offset=0;

    length= 24;

        // resize the handle and write.
    if(MemHandleResize(pwDBrec, length)==0)
    {
        ch=MemHandleLock(pwDBrec);
        DmWrite(ch, offset,  pass, length);
        MemHandleUnlock(pwDBrec);
    }
}

/*********************************************************************
 * Function: getSystemSizeA
 * Description: pass the function a pointer to a system and it 
 * will return the buffer length needed to hold that system when
 * it is encrypted. 
 * Note: uses getSCSize function included from twDriver.c
 * *******************************************************************/
static UInt getSystemSizeA(System *sys)
{
    UInt length=0;
    length= sizeof(sys->SystemID)+StrLen(sys->name)+1;
    return getSCSizeB(length);
}

/*********************************************************************
 * Function: getSystemSizeB
 * Description: pass the function a pointer to a system and it 
 * will return the buffer length needed to hold that system when
 * it is encrypted. 
 * Note: uses getSCSize function included from twDriver.c
 * *******************************************************************/
static UInt getSystemSizeB(System *sys)
{
    UInt length=0;
    length= sizeof(sys->SystemID)+StrLen(sys->name)+1;
    return getSCSizeB(length);
}

/*********************************************************************
 * Function: getAccountSizeA
 * Description: pass the function a pointer to an account and a boolean
 * for whether or not the account will be encrypted and it
 * will return the buffer length needed to hold that account. 
 * Note: uses getSCSize function included from twDriver.c
 * *******************************************************************/
static UInt getAccountSizeA(Account *acct, Boolean enc)
{
    UInt length=0;
    length= sizeof(acct->SystemID)+sizeof(acct->AccountID)+
        StrLen(acct->username)+StrLen(acct->password)+
        StrLen(acct->type)+StrLen(acct->comment)+4;

        // if the account will be encrypted call getSCSize, 
        // otherwise just return the raw length
    if(enc)
        return getSCSizeB(length);
    else
        return length;
}

/*********************************************************************
 * Function: getAccountSizeB
 * Description: pass the function a pointer to an account and a boolean
 * for whether or not the account will be encrypted and it
 * will return the buffer length needed to hold that account. 
 * Note: uses getSCSize function included from twDriver.c
 * *******************************************************************/
static UInt getAccountSizeB(Account *acct, Boolean enc)
{
    UInt length=0;
    length= sizeof(acct->SystemID)+sizeof(acct->AccountID)+
        StrLen(acct->username)+StrLen(acct->password)+
        StrLen(acct->type)+StrLen(acct->comment)+4;

        // if the account will be encrypted call getSCSize, 
        // otherwise just return the raw length
    if(enc)
        return getSCSizeB(length);
    else
        return length;
}

/********************************************************************
 * Function: addAccount
 * Description:  function responsible for writing a packed account record
 * to the database. This function is slightly different than addPassword
 * or addSystem. In order to increase search speed in the account 
 * database we will write the systemID of the account to the database
 * without encrypting it. not that this is the systemID that the program
 * uses internally, it has nothing to do with real user data.
 * ******************************************************************/
static void addAccount(UInt sysID, RecordBuffer acct, VoidHand acctDBrec)
{
    UInt length=0;
    CharPtr ch;
    UInt offset=0;
    Err err;
        
        // calculate the size
    length= MemPtrSize(acct)+sizeof(sysID);

        // resize the handle and write.
    if(MemHandleResize(acctDBrec, length)==0)
    {
        ch=MemHandleLock(acctDBrec);
        DmWrite(ch, offset,  &sysID, sizeof(sysID));
        offset+=sizeof(sysID);
        DmWrite(ch, offset,  acct, MemPtrSize(acct));
        MemHandleUnlock(acctDBrec);
    }
}

/***************************************************************************
 * Function: changePassword
 * Description: handles changing the system password based upon the 
 * password change screen. Basically checks that current password is correct,
 * checks that the new password was entered correctly, then re-encrypts the
 * databases based upon the new password.
 * ************************************************************************/
static void twToIdea(void)
{
        // total number of records to re-write
    UInt totalAItems=DmNumRecordsInCategory(AccountDB, dmAllCategories);
    UInt totalSItems=DmNumRecordsInCategory(SystemDB, dmAllCategories);
    RecordBuffer pac=NULL, scratch=NULL, scratch2=NULL;
    UInt i=0, index=0, senc=0 ,aenc=0;
    VoidHand rH;                    
    char s[5], a[5];

        // re-encrypt the password 
    if(rH=DmGetRecord(PasswordDB, 0))
    {   
        if(scratch=MemPtrNew(24))
        {
            PackPasswordB(scratch, SysPass);
            addPassword(scratch, rH);            
            MemPtrFree(scratch);
        }
        DmReleaseRecord(PasswordDB, 0, true); 
    }
    
        // loop through the systems and re-encrypt
    for(i=0; i< totalSItems; i++)
    {
        System sys;
        if(rH=DmGetRecord(SystemDB, i))
        {
            pac=MemHandleLock(rH);
            if(scratch=MemPtrNew(MemPtrSize(pac)))
            {
                    // decrypt the system with old password
                UnpackSystemA(&sys, pac, scratch, SysPass, MemHandleSize(rH), true);
                if(scratch2=MemPtrNew(getSystemSizeB(&sys)))
                {
                        // re-encrypt with new password
                    PackSystemB(scratch2, sys, SysPass, true); 
                    MemHandleUnlock(rH);
                    addSystem(scratch2, rH);
                    senc++;
                    MemPtrFree(scratch2);
                }
                MemPtrFree(scratch);
            }
            
            DmReleaseRecord(SystemDB, i, true);
        }
    }
    
        // loop through the accounts and re-encrypt
    for(i=0; i< totalAItems; i++)
    {
        UInt id;
        Account ac;
        if(rH=DmGetRecord(AccountDB, i))
        {
            pac=MemHandleLock(rH);
            if(scratch=MemPtrNew(MemPtrSize(pac)))
            {
            
                    // decrypt the system with old password
                UnpackAccountA(&ac, pac, scratch, SysPass, MemHandleSize(rH), true, true);
                id=ac.SystemID;
                if(scratch2=MemPtrNew(getAccountSizeB(&ac, true)))
                {
                        // re-encrypt with new password
                    PackAccountB(scratch2, ac, SysPass, true); 
                    MemHandleUnlock(rH);
                    addAccount(id, scratch2, rH); 
                    aenc++ ;
                    MemPtrFree(scratch2);
                }
                MemPtrFree(scratch);
            }
            
            DmReleaseRecord(AccountDB, i, true);
        }
    }
    
    StrIToA(s, senc);
    StrIToA(a, aenc);

    FrmCustomAlert(infoDialog, s, a, NULL);
    StopApplication();
    SysReset();
    
}

/***************************************************************************
 * Function: changePassword
 * Description: handles changing the system password based upon the 
 * password change screen. Basically checks that current password is correct,
 * checks that the new password was entered correctly, then re-encrypts the
 * databases based upon the new password.
 * ************************************************************************/
static void ideaToTw(void)
{
        // total number of records to re-write
    UInt totalAItems=DmNumRecordsInCategory(AccountDB, dmAllCategories);
    UInt totalSItems=DmNumRecordsInCategory(SystemDB, dmAllCategories);
    RecordBuffer pac=NULL, scratch=NULL, scratch2=NULL;
    UInt i=0, index=0, senc=0 ,aenc=0;
    VoidHand rH;                    
    char s[5], a[5];

        // re-encrypt the password 
    if(rH=DmGetRecord(PasswordDB, 0))
    {   
        if(scratch=MemPtrNew(24))
        {
            PackPasswordA(scratch, SysPass);
            addPassword(scratch, rH);            
            MemPtrFree(scratch);
        }
        DmReleaseRecord(PasswordDB, 0, true); 
    }
    
        // loop through the systems and re-encrypt
    for(i=0; i< totalSItems; i++)
    {
        System sys;
        if(rH=DmGetRecord(SystemDB, i))
        {
            pac=MemHandleLock(rH);
            if(scratch=MemPtrNew(MemPtrSize(pac)))
            {
                    // decrypt the system with old password
                UnpackSystemB(&sys, pac, scratch, SysPass, MemHandleSize(rH), true);
                if(scratch2=MemPtrNew(getSystemSizeA(&sys)))
                {
                        // re-encrypt with new password
                    PackSystemA(scratch2, sys, SysPass, true); 
                    MemHandleUnlock(rH);
                    addSystem(scratch2, rH);
                    senc++;
                    MemPtrFree(scratch2);
                }
                MemPtrFree(scratch);
            }
            
            DmReleaseRecord(SystemDB, i, true);
        }
    }
    
        // loop through the accounts and re-encrypt
    for(i=0; i< totalAItems; i++)
    {
        UInt id;
        Account ac;
        if(rH=DmGetRecord(AccountDB, i))
        {
            pac=MemHandleLock(rH);
            if(scratch=MemPtrNew(MemPtrSize(pac)))
            {
            
                    // decrypt the system with old password
                UnpackAccountB(&ac, pac, scratch, SysPass, MemHandleSize(rH), true, true);
                id=ac.SystemID;
                if(scratch2=MemPtrNew(getAccountSizeA(&ac, true)))
                {
                        // re-encrypt with new password
                    PackAccountA(scratch2, ac, SysPass, true); 
                    MemHandleUnlock(rH);
                    addAccount(id, scratch2, rH); 
                    aenc++ ;
                    MemPtrFree(scratch2);
                }
                MemPtrFree(scratch);
            }
            
            DmReleaseRecord(AccountDB, i, true);
        }
    }
    
    StrIToA(s, senc);
    StrIToA(a, aenc);

    FrmCustomAlert(infoDialog, s, a, NULL);
    StopApplication();
    SysReset();
    
}

/********************************************************************
 * Function: DrawCharsToFitWidth
 * Description: simple utility call that will draw the chars of string
 * s into the rectange bounds. This is the function we use to 
 * draw the lists to the screen.
 * ******************************************************************/
static void DrawCharsToFitWidth(char *s, RectanglePtr r)
{
    SWord strLen=StrLen(s);
    SWord pixelWidth= r->extent.x;
    Boolean truncate;

    FntCharsInWidth(s, &pixelWidth, &strLen, &truncate);
    WinDrawChars(s, strLen, r->topLeft.x, r->topLeft.y);
}

/********************************************************************************
 * Function: StartApplication
 * Description: This is the first function that gets called and it is 
 * responsible for initializing databases and other global variables, checking
 * to see whether private records will be shown and calculating the auto-off time
 * for the current system.
 * ******************************************************************************/
static Err StartApplication(void)
{
    UInt mode=dmModeReadWrite;
    Err errors=0;
    Boolean created;

        // set current form to be the password opener
    currentForm= PasswordForm; 

        // check about private records
    hideSecretRecords=PrefGetPreference(prefHidePrivateRecords);
    if(!hideSecretRecords)
        mode |= dmModeShowSecret;


        // open or create databases.
    errors=getDatabase(&SystemDB, systemDBType, StripCreator, mode, 0, systemDBName, &created); 
    errors=getDatabase(&AccountDB, accountDBType, StripCreator, mode, 0, accountDBName, &created); 
    errors=getDatabase(&PasswordDB, passwordDBType, StripCreator, mode, 0, passwordDBName, &created); 
    
        // if the password database does not exist, or there are no records in it note that 
        // this is the first run, so the user will be prompted to enter a new password.
    if(created||(DmNumRecordsInCategory(PasswordDB, dmAllCategories)==0))
    {
        firstRun=true;
    }
    
        // set up the timer stuff.  start by setting auto off time to 0. the function returns the old 
        // auto off time. If the oldAutoOffTime is 0 then the system will never shut down. this is not
        // the behavior that we want, so we reset the autoOffTime to 300. if the oldAutoOffTime is not 
        // 0 then we set it back immediatly.  Note that in the StopApplication function we 
        // set the autoOffTime back to what it was before this program started no matter what.
    
    return 0;
}

/************************************************************************
 * Function: StopApplication
 * Description:  this function is responsible for stopping all application
 * related activity, freeing used memory, resetting the auto-off time, and
 * closing the databases.
 * **********************************************************************/
static void StopApplication(void)
{
   
    FrmCloseAllForms();

        // close databases.
    DmCloseDatabase(SystemDB);
    DmCloseDatabase(AccountDB);
    DmCloseDatabase(PasswordDB);
}

/*****************************************************************************
 * Function: changeForm
 * Description: utility function that changes the current form and tracks
 * the current and last form shown.
 * ***************************************************************************/
static void changeForm(Word id)
{
    oldForm=currentForm;
        
        // this function changes the current form and sends a form load event.
    FrmGotoForm(id);
    currentForm=id;
}

/********************************************************************************
 * Function: checkPassword
 * Description: this is the function responsible for checking the 
 * input password value of the authentication form. 
 * ******************************************************************************/
static void checkPassword(void)
{
    RecordBuffer pass1, scratch=NULL;
    char * input;   
    UInt recNum=0, index=0, len, len2;
    VoidHand rec;
    mdKey in, saved;
    
        // compact text and get a pointer.
    FldCompactText(GetObjectFromActiveForm(PasswordField));
    input=FldGetTextPtr(GetObjectFromActiveForm(PasswordField));
    
        // if SysPass is defined, free it. this happens when Strip locks
        // itself after the timeout.
    if(SysPass)
        MemPtrFree(SysPass);
        
        // if its the first time the user has used the program we need 
        // to set some things up. 
    
    if(input&&StrLen(input))
    {
            // read the password from the database, decrypt with the input text.
        if(rec=DmQueryRecord(PasswordDB,index)) 
        {
            pass1 = MemHandleLock(rec);
            if(scratch=MemPtrNew(24))
            {
                if(oldtonew)
                    UnpackPasswordA(pass1, scratch, input);
                else if(newtoold)
                    UnpackPasswordB(pass1, scratch, input);
            }
            MemHandleUnlock(rec);
        }
                   
            // the message digest of the password they provided should be exactly the
            // same as the message digest that was just decrypted out of the password
            // database. Do a MemCmp to make sure they are the same.
        MDString(input, in, oldtonew); /* Use wrong endianness if old to new */
    
        if((!MemCmp(in, scratch, 16))&&input)
        {
                // if so, copy the password onto the system-password
            if(SysPass=MemPtrNew(StrLen(input)+1))
                StrCopy(SysPass, input);
            
            
            if(scratch)
                MemPtrFree(scratch);
                
            if(oldtonew)
                twToIdea();        
            else if(newtoold)
                ideaToTw();

        }
        else
        {
                // FAILURE!!!!!!
                // free the memory and tell the user they entered the wrong password.
            FieldPtr fld=GetObjectFromActiveForm(PasswordField);
            FrmCustomAlert(GenericError, "The password you entered is incorrect", NULL, NULL);
            FldSetSelection(fld, 0, FldGetTextLength(fld));
        
            if(scratch)
            {
               MemPtrFree(scratch);
               SysPass=NULL;
            }
        }
    }
        // null string is always wrong!!!
    else
        FrmCustomAlert(GenericError, "The password you entered is incorrect", NULL, NULL);    
}

/************************************************************************************
 * Function: UnpackSystemA
 * Description: This is a utility function that will take a packed System ,
 * optionally decrypt it based on the passed in password, and set up 
 * an unpacked system. 
 * **********************************************************************************/
static void UnpackSystemA(System * sys, RecordBuffer  p, RecordBuffer  scratch, char * pass, UInt recLen, Boolean decrypt)
{
    PSystem * psys ;
    char *s;

        // if necessary, decrypt, otherwise just copy the memory to the scratch buffer
    if(decrypt)
        stripCryptA(SysPass, p, scratch, recLen , 0);
    else
        MemMove(p, scratch, recLen);

        // set up the system, pointing the name to the first char in the name string.
    psys=(PSystem *) scratch;
    s = psys->name;
    sys->SystemID=psys->SystemID;
    sys->name=s;
    s+=StrLen(s)+1;
}

/************************************************************************************
 * Function: UnpackSystemB
 * Description: This is a utility function that will take a packed System ,
 * optionally decrypt it based on the passed in password, and set up 
 * an unpacked system. 
 * **********************************************************************************/
static void UnpackSystemB(System * sys, RecordBuffer  p, RecordBuffer  scratch, char * pass, UInt recLen, Boolean decrypt)
{
    PSystem * psys ;
    char *s;

        // if necessary, decrypt, otherwise just copy the memory to the scratch buffer
    if(decrypt)
        stripCryptB(SysPass, p, scratch, recLen , 0);
    else
        MemMove(p, scratch, recLen);

        // set up the system, pointing the name to the first char in the name string.
    psys=(PSystem *) scratch;
    s = psys->name;
    sys->SystemID=psys->SystemID;
    sys->name=s;
    s+=StrLen(s)+1;
}

/************************************************************************************
 * Function: PackSystemA
 * Description: Utility function that takes an unpacked system, optionally encrypts
 * it and packs it into a buffer, strings are seperated by null characters. puts the 
 * content in retbuffer
 * *********************************************************************************/
static void PackSystemA(RecordBuffer  retbuff, System sys, char * pass, Boolean encrypt)
{
    UInt offset=0;
    RecordBuffer psys;
    if(psys=MemPtrNew(MemPtrSize(retbuff)))
    {   
            // move the data into the buffer.
        MemMove(psys+offset, &sys.SystemID, sizeof(sys.SystemID));
        offset+=sizeof(sys.SystemID);
    
        MemMove(psys+offset,sys.name, StrLen(sys.name)+1);
        offset+=StrLen(sys.name)+1;
    
            //optionally decrypt it.
        if(encrypt)
            stripCryptA(pass, psys,retbuff, getSystemSizeA(&sys), 1);
        else
            MemMove(retbuff,psys, getSystemSizeA(&sys));
    
        MemPtrFree(psys);
    }
}

/************************************************************************************
 * Function: PackSystemB
 * Description: Utility function that takes an unpacked system, optionally encrypts
 * it and packs it into a buffer, strings are seperated by null characters. puts the 
 * content in retbuffer
 * *********************************************************************************/
static void PackSystemB(RecordBuffer  retbuff, System sys, char * pass, Boolean encrypt)
{
    UInt offset=0;
    RecordBuffer psys;
    if(psys=MemPtrNew(MemPtrSize(retbuff)))
    {   
            // move the data into the buffer.
        MemMove(psys+offset, &sys.SystemID, sizeof(sys.SystemID));
        offset+=sizeof(sys.SystemID);
    
        MemMove(psys+offset,sys.name, StrLen(sys.name)+1);
        offset+=StrLen(sys.name)+1;
    
            //optionally decrypt it.
        if(encrypt)
            stripCryptB(pass, psys,retbuff, getSystemSizeB(&sys), 1);
        else
            MemMove(retbuff,psys, getSystemSizeB(&sys));
    
        MemPtrFree(psys);
    }
}

/***********************************************************************************
 * Function: UnpackPasswordA
 * Description: unpack a password and decrpt it using spass
 * *********************************************************************************/
static void UnpackPasswordA(RecordBuffer p, RecordBuffer scratch, char * spass)
{
    stripCryptA(spass, p, scratch, 24 , 0);
}

/***********************************************************************************
 * Function: UnpackPasswordB
 * Description: unpack a password and decrpt it using spass
 * *********************************************************************************/
static void UnpackPasswordB(RecordBuffer p, RecordBuffer scratch, char * spass)
{
    stripCryptB(spass, p, scratch, 24 , 0);
}

/***********************************************************************************
 * Function: PackPasswordA
 * Description: pack a password and encrypt it using spass
 * *********************************************************************************/
static void PackPasswordA(RecordBuffer retbuff, char * spass)
{                     
    mdKey pw;
    RecordBuffer ppass;
    if(ppass=MemPtrNew(24)) 
    {
        MDString(spass, pw, 1); /* Use wrong endianness */
        MemMove(ppass, pw, sizeof(pw));
        stripCryptA(spass, ppass, retbuff, 24, 1); 
        MemPtrFree(ppass);
    }
}

/***********************************************************************************
 * Function: PackPasswordB
 * Description: pack a password and encrypt it using spass
 * *********************************************************************************/
static void PackPasswordB(RecordBuffer retbuff, char * spass)
{                     
    mdKey pw;
    RecordBuffer ppass;
    if(ppass=MemPtrNew(24)) 
    {
        MDString(spass, pw, 0);
        MemMove(ppass, pw, sizeof(pw));
        stripCryptB(spass, ppass, retbuff, 24, 1); 
        MemPtrFree(ppass);
    }
}

    
/************************************************************************************
 * Function: UnpackAccountA
 * Description: This is a utility function that will take a packed account ,
 * optionally decrypt it based on the passed in password, and set up 
 * an unpacked account. isRec determines whether the packed account is a full record.
 * remember that fullrecords have the plaintext system id prepended, so if it
 * is a full record we will ignore this space.
 * **********************************************************************************/
static void UnpackAccountA(Account * acct, RecordBuffer  p, RecordBuffer  scratch, char * pass, UInt recLen, Boolean decrypt, Boolean isRec)
{
    PAccount * pacct ;
    char *s;
    UInt offset=sizeof(offset);
    recLen=recLen-offset;
        
        // decrypt if neccessary
    if(decrypt)
        stripCryptA(pass, p+offset, scratch, recLen , 0);
    else
            // if buffer has the systemID header disregard it.
        if(isRec)
            MemMove(scratch, p+offset, recLen);
        else
            MemMove(scratch, p, recLen);

        // split record up into its different components.   
    pacct=(PAccount *) scratch;
    s = pacct->username;
    acct->SystemID=pacct->SystemID;
    acct->AccountID=pacct->AccountID;
    acct->username=s;
    s+=StrLen(s)+1;
    acct->password=s;
    s+=StrLen(s)+1;
    acct->type=s;
    s+=StrLen(s)+1;
    acct->comment=s;
    s+=StrLen(s)+1;
}

/************************************************************************************
 * Function: UnpackAccountB
 * Description: This is a utility function that will take a packed account ,
 * optionally decrypt it based on the passed in password, and set up 
 * an unpacked account. isRec determines whether the packed account is a full record.
 * remember that fullrecords have the plaintext system id prepended, so if it
 * is a full record we will ignore this space.
 * **********************************************************************************/
static void UnpackAccountB(Account * acct, RecordBuffer  p, RecordBuffer  scratch, char * pass, UInt recLen, Boolean decrypt, Boolean isRec)
{
    PAccount * pacct ;
    char *s;
    UInt offset=sizeof(offset);
    recLen=recLen-offset;
        
        // decrypt if neccessary
    if(decrypt)
        stripCryptB(pass, p+offset, scratch, recLen , 0);
    else
            // if buffer has the systemID header disregard it.
        if(isRec)
            MemMove(scratch, p+offset, recLen);
        else
            MemMove(scratch, p, recLen);

        // split record up into its different components.   
    pacct=(PAccount *) scratch;
    s = pacct->username;
    acct->SystemID=pacct->SystemID;
    acct->AccountID=pacct->AccountID;
    acct->username=s;
    s+=StrLen(s)+1;
    acct->password=s;
    s+=StrLen(s)+1;
    acct->type=s;
    s+=StrLen(s)+1;
    acct->comment=s;
    s+=StrLen(s)+1;
}

/************************************************************************************
 * Function: PackAccountA
 * Description: Utility function that takes an unpacked account, optionally encrypts
 * it and packs it into a buffer, strings are seperated by null characters. puts the 
 * content in retbuffer
 * *********************************************************************************/
static void PackAccountA(RecordBuffer retbuff, Account acct, char * pass, Boolean encrypt)
{
    UInt offset=0;
    RecordBuffer pacct;
    if(pacct=MemPtrNew(MemPtrSize(retbuff)))
    {  
            // pack the fields of the account buffer together
        MemMove(pacct+offset, &acct.SystemID, sizeof(acct.SystemID));
        offset+=sizeof(acct.SystemID);
        MemMove(pacct+offset, &acct.AccountID, sizeof(acct.AccountID));
        offset+=sizeof(acct.AccountID);
        MemMove(pacct+offset,acct.username, StrLen(acct.username)+1);
        offset+=StrLen(acct.username)+1;
        MemMove(pacct+offset,acct.password, StrLen(acct.password)+1);
        offset+=StrLen(acct.password)+1;
        MemMove(pacct+offset, acct.type, StrLen(acct.type)+1);
        offset+=StrLen(acct.type)+1;
        MemMove(pacct+offset,acct.comment, StrLen(acct.comment)+1);
        offset+=StrLen(acct.comment)+1;
    
            // optionally encrypt
        if(encrypt)
            stripCryptA(pass, pacct,retbuff, getAccountSizeA(&acct, true), 1);
        else
            MemMove(retbuff, pacct, getAccountSizeA(&acct, true));
    
        MemPtrFree(pacct);
    }
}

/************************************************************************************
 * Function: PackAccountB
 * Description: Utility function that takes an unpacked account, optionally encrypts
 * it and packs it into a buffer, strings are seperated by null characters. puts the 
 * content in retbuffer
 * *********************************************************************************/
static void PackAccountB(RecordBuffer retbuff, Account acct, char * pass, Boolean encrypt)
{
    UInt offset=0;
    RecordBuffer pacct;
    if(pacct=MemPtrNew(MemPtrSize(retbuff)))
    {  
            // pack the fields of the account buffer together
        MemMove(pacct+offset, &acct.SystemID, sizeof(acct.SystemID));
        offset+=sizeof(acct.SystemID);
        MemMove(pacct+offset, &acct.AccountID, sizeof(acct.AccountID));
        offset+=sizeof(acct.AccountID);
        MemMove(pacct+offset,acct.username, StrLen(acct.username)+1);
        offset+=StrLen(acct.username)+1;
        MemMove(pacct+offset,acct.password, StrLen(acct.password)+1);
        offset+=StrLen(acct.password)+1;
        MemMove(pacct+offset, acct.type, StrLen(acct.type)+1);
        offset+=StrLen(acct.type)+1;
        MemMove(pacct+offset,acct.comment, StrLen(acct.comment)+1);
        offset+=StrLen(acct.comment)+1;
    
            // optionally encrypt
        if(encrypt)
            stripCryptB(pass, pacct,retbuff, getAccountSizeB(&acct, true), 1);
        else
            MemMove(retbuff, pacct, getAccountSizeB(&acct, true));
    
        MemPtrFree(pacct);
    }
}

/****************************************************************************
 * Function: PasswordHandleEvent
 * Description: callback function that handles events for the form that
 * checks the password to login to the program. This one is a little tricky
 * . We accomplish an "echo-off" mode by covering the text the user writes
 * with a field contating '*' characters.  If you look at source file Strip.rcp
 * you will see that there are actually two fields that occupy the same exact
 * pixel locations on the field. which ever one is drawn last is the
 * one that will show up. If the user clicks the "echo-off" checkbox on 
 * the screen It will draw the CoverPasswordField over the actual password
 * field.  We therefore need to intecept any key down events that 
 * come into the event queue in order to handle the echo off stuff. This 
 * also poses a problem with selection. We need to make sure that the fields
 * both have the same selections and the same insertion points or it 
 * is confusing to the user. This function is called immediatly before
 * the default event handler, so it should never interfere with system
 * events.If anybody can think of a better way to allow
 * echo off, please let me know.
 * ************************************************************************/
static Boolean PasswordHandleEvent(EventPtr event)
{
    Boolean     handled, tmp;
    Word c, bak, startP, endP;
#ifdef __GNUC__
    CALLBACK_PROLOGUE
#endif
    handled = false;
    switch (event->eType)
    {   
            
        case ctlSelectEvent:
            switch(event->data.ctlSelect.controlID)
            {

                    // they clicked ok, so check the password
                case PasswordOk:
                    checkPassword();
                    break;
                
                case oldToNewIdea:
                    tmp=CtlGetValue(GetObjectFromActiveForm(oldToNewIdea));
                    oldtonew=tmp;
                    newtoold=!tmp;
                    CtlSetValue(GetObjectFromActiveForm(newToOldIdea), newtoold);
                break;
                
                case newToOldIdea:
                    tmp=CtlGetValue(GetObjectFromActiveForm(newToOldIdea));
                    newtoold=tmp;
                    oldtonew=!tmp;
                    CtlSetValue(GetObjectFromActiveForm(oldToNewIdea), oldtonew);
                break;
            
            }
            handled=true;
            break;

        case frmOpenEvent:  
            CtlSetValue(GetObjectFromActiveForm(oldToNewIdea), true);
            CtlSetValue(GetObjectFromActiveForm(newToOldIdea), false);
            FrmDrawForm(FrmGetActiveForm());
            FrmSetFocus(FrmGetActiveForm(), FrmGetObjectIndex(FrmGetActiveForm(),PasswordField));
                
                // if its the first run, pop up a dialog letting them know that the password they choose will be
                // the one that they get
            
            handled = true;
            break;
            
            
    }
#ifdef __GNUC__
    CALLBACK_EPILOGUE
#endif
    return(handled);
}

/************************************************************************
 * Function: GetFocusObjectPtr
 * Description: return a pointer to whatever UI object currently has
 * the input focus
 * *********************************************************************/
static FieldPtr GetFocusObjectPtr(void)
{
    FormPtr frm;
    Word focus;
    FormObjectKind objType;

    frm=FrmGetActiveForm();
    focus=FrmGetFocus(frm);
        
        // if no focus return null
    if(focus==noFocus)
        return NULL;

    objType=FrmGetObjectType(frm, focus);

    if(objType == frmFieldObj)
        return (FrmGetObjectPtr(frm, focus));

        // handle tables, this version of strip currently doesnt have any tables
        // but who knows, it might someday
    else if(objType==frmTableObj)
        return (TblGetCurrentField (FrmGetObjectPtr(frm, focus)));

    return NULL;
}

/*********************************************************************
 * Function: ApplicationHandleEvent
 * Description: this is the event handler that we use to 
 * set up forms on frmLoadEvents. It sets the event handlers
 * for every other non modal form in the program
 * *******************************************************************/
static Boolean ApplicationHandleEvent(EventPtr event)
{
    FormPtr frm;
    Int     formId;
    Boolean handled = false;

    if (event->eType == frmLoadEvent)
    {
            // load and activate the requested form
        formId = event->data.frmLoad.formID;
        frm = FrmInitForm(formId);
        FrmSetActiveForm(frm);

            // set an event handler
        switch (formId)
        {               
            case PasswordForm:
                FrmSetEventHandler(frm, PasswordHandleEvent);
                break;
        }
        handled = true;
    }
    
    return handled;
}

/**********************************************************************
 * Function: EventLoop
 * Description: this is the main event loop for the program. It 
 * listens for events for .5 seconds, if none come in, it checks 
 * wheter it should timeout and lock the program. If the unit
 * is scheduled to sleep within the next five seconds, it locks
 * the display. 
 * Note: timeout does not work properly if you overclock you 
 * palm's processor.
 * ********************************************************************/
static void EventLoop(void)
{
    EventType event;
    Word error;
        
        // get number of processor ticks that occur per second on
        // this device.
    
    do
    {
            // wait a bit for an event
        EvtGetEvent(&event, 50);
       
                // first the system gets the event, then the Menu event handler, then the application
                // event handler, then finally the form event handler
            if (! SysHandleEvent(&event))
                if (! MenuHandleEvent(0, &event, &error))
                    if (! ApplicationHandleEvent(&event))
                        FrmDispatchEvent(&event);        
    }
    while (event.eType != appStopEvent);
}

/**********************************************************************************
 * Function: PilotMain
 * Description: this is the function that is acctually called by the PalmOS when
 * application start and other events occur. we handle those system launch events
 * here
 * *******************************************************************************/
DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
    Err err = 0;        
    
        // request to start application normally
    if (cmd == sysAppLaunchCmdNormalLaunch)
    {
            // call StartApplication to initialize things, 
            // go to the opening form and enter the event loop,
            // until end.
        if ((err = StartApplication()) == 0)
        {
            FrmGotoForm(PasswordForm);
            EventLoop();
            StopApplication();
        }
    }
}

