#!/bin/ksh
## -- AIX/6000 System monitor 
##
##     vmker.sh
##
## Copyright (c) 1998-2001 Marcel Mol, All Rights Reserved.
## NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
## THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
## COPYRIGHTS.
##

d=`date +%Y%m%d%H%M%S`

exec > vmker.log.$d

echo "=============="
echo " Starting at $d"
echo "oslevel `oslevel` on `uname -a`"


#
# From the monitor distribution
#
echo "\n==== Running vmker ===="
./vmker  # > vmker.out.$d

#
# from /usr/lpp/samples/...
# or   /usr/samples/...
#
echo "\n==== Running vmtune ===="
VMT=/usr/samples/kernel/vmtune
if [ ! -x $VMT ] ; then
    VMT=/usr/lpp/samples/kernel/vmtune
    if [ ! -x $VMT ] ; then
        VMT=""
        echo "===== vmtune not found, skipping test"
    fi
fi
    
if [ ! -z "$VMT" ] ; then
    $VMT # > vmtune.out.$d
fi

#
# standard AIX tool
#
echo "\n==== Running lsdev -C ===="
lsdev -C | grep mem # > mem.out.$d
echo "\n==== Running lsps -a ===="
lsps -a # >  page.out.$d
echo "\n==== Running svmon -G ===="
svmon -G #> svmon.out.$d
# echo "\n==== Running svmon -Pau ===="
# svmon -Pau # > svmon.out2.$d

echo "\n==== Running schedtune ===="
SCT=/usr/samples/kernel/schedtune
if [ ! -x $SCT ] ; then
    SCT=/usr/lpp/samples/kernel/schedtune
    if [ ! -x $VMT ] ; then
        SCT=""
        echo "===== schedtune not found, skipping test"
    fi
fi
    
if [ ! -z "$SCT" ] ; then
    $SCT # > schedtune.out.$d
fi
