/* -- AIX/6000 System monitor 
**
**     vmker.c
**
** Copyright (c) 1998-2001 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <unistd.h>
#include <stdio.h>
#include <nlist.h>
#include <fcntl.h>
#include <sys/types.h>
#include "config.h"


#define VMK_SIZE 50

/*
 * vmker struct is kernelstruct (undocumented) 
 * vmker seems to hold some kernels virtual memory variables 
 * vmker1 works up to AIX 4.2
 */
struct vmker1 {
    uint n0, n1, n2, n3, n4, n5, n6, n7;
    uint pageresv; /* reserved paging space blocks */
    uint totalmem; /* total number of pages memory */
    uint badmem;   /* this is used in RS/6000 model 220 and C10 */
    uint freemem;  /* number of pages on the free list */
    uint maxperm;  /* max number of frames no working */
    uint numperm;  /* seems to keep other than text and data segment usage */
                   /* the name is taken from /usr/lpp/bos/samples/vmtune.c */
    uint totalvmem;
    uint freevmem;
    uint n16;
    uint nonpinnable; /* number of reserved (non-pinable) memory pages */
    uint n18, n19;
    uint numclient;/* number of client frames */
    uint maxclient;/* max number of client frames */
    uint n22, n23;
    uint n24, n25;
    uint n26, n27;
    uint n28, n29;
    uint n30, n31;
    uint n32, n33;
    uint n34, n35;
    uint n36, n37;
    uint n38, n39;
    uint n40, n41;
    uint n42, n43;
    uint n44, n45;
    uint n46, n47;
};

/*
 * vmker2 works for AIX 4.3
 */
struct vmker2 {
    uint n0, n1, n2, n3, n4, n5, n6, n7;
    uint totalmem; /* total number of pages memory */
    uint badmem;   /* this is used in RS/6000 model 220 and C10 */
    uint freemem;  /* number of pages on the free list */
    uint maxperm;  /* max number of frames no working */
    uint numperm;  /* seems to keep other than text and data segment usage */
                   /* the name is taken from /usr/lpp/bos/samples/vmtune.c */
    uint totalvmem;
    uint n14;
    uint freevmem;
    uint nonpinnable; /* number of reserved (non-pinable) memory pages */
    uint pageresv; /* reserved paging space blocks */
    uint n18;
    uint numclient;/* number of client frames */
    uint maxclient;/* max number of client frames */
    uint n21;
    uint n22, n23;
    uint n24, n25;
    uint n26, n27;
    uint n28, n29;
    uint n30, n31;
    uint n32, n33;
    uint n34, n35;
    uint n36, n37;
    uint n38, n39;
    uint n40, n41;
    uint n42, n43;
    uint n44, n45;
    uint n46, n47;
};


void get_vm_info(uint *vmk, int bufsize);
int getkmemdata(void *buf, int bufsize, caddr_t address);

#define N_VALUE(index) ((caddr_t)kernelnames[index].n_value)
#define KNSTRUCTS_CNT 1
#define NLIST_VMKER 0

struct nlist kernelnames[] = {
    {"vmker",   0, 0, 0, 0, 0},
    {NULL,      0, 0, 0, 0, 0},
};

int kmemfd = -1;
int nlistdone = 0;

/***************************************************************************
 *                      DATA CAPTURE FUNCTIONS                             *
 ***************************************************************************/

int getkmemdata(void *buf, int bufsize, caddr_t address)
{
    int n;

    /*
     * Do stuff we only need to do once per invocation, like opening
     * the kmem file and fetching the parts of the symbol table.
     */
    if (kmemfd < 0) {
	if ((kmemfd = open("/dev/kmem", O_RDONLY)) < 0) {
	    perror("kmem");
	    exit(1);
	}
    }
    /*
     * Get the structure from the running kernel.
     */
    lseek(kmemfd, (off_t) address, SEEK_SET);
    n = read(kmemfd, buf, bufsize);

    return(n);

} /* getkmemdata */



void get_vm_info(uint *vmk, int bufsize)
{

    if (!nlistdone) {
        if (knlist(kernelnames, KNSTRUCTS_CNT, sizeof(struct nlist)) == -1)
	    perror("knlist, entry not found");
        nlistdone = 1;
    }

    /*
     * Get the kernel virtual memory vmker structure
     */
    getkmemdata(vmk, bufsize, N_VALUE(NLIST_VMKER));

    return;

} /* get_vm_info */


#define P(v, f)  (uint)(&v->f - (uint *)v), v->f, (float) v->f * 4 / 1024
#define A(f)     P(vmk1, f), P(vmk2, f)

main()
{
    uint vmk[VMK_SIZE];
    struct vmker1 *vmk1 = (struct vmker1 *)vmk;
    struct vmker2 *vmk2 = (struct vmker2 *)vmk;
    unsigned char * v;
    int i;
    uint j;


    printf("This is vkmer from monitor %s compiled for AIX %d.%d.%d\n",
            MON_VERSION, AIX_VERSION, AIX_RELEASE, AIX_LEVEL);

    get_vm_info(vmk, sizeof (uint) * VMK_SIZE);


    v = (char *) &vmk;
    j = 0;
    for (i = 0; i <sizeof(vmk); i++) {
        if (i % 4) {
            putchar(' ');
        }
        else {
            if (i > 0) 
                printf("  %11d %11.1f\nn%02d: ", j, j * 4 / 1024.0, i / 4);
            else
                printf("n00: ");
            j = 0;
        }
        printf("%02X", v[i]);
        j = (j << 8) | v[i];
    }
    printf("  %11d %11.1f\n", j, j * 4 / 1024.0);


    printf("Fieldname  Field  Pages  MB   <4.3  |   >=4.3\n");
    printf("totalmem   (n%02d) %10d %8.1f|(n%02d) %10d %9.1f Total memory\n", A(totalmem));
    printf("freemem    (n%02d) %10d %8.1f|(n%02d) %10d %9.1f Available free memory\n", A(freemem));
    printf("badmem     (n%02d) %10d %8.1f|(n%02d) %10d %9.1f\n", A(badmem));
    printf("numperm    (n%02d) %10d %8.1f|(n%02d) %10d %9.1f Allocated to files\n", A(numperm));
    printf("maxperm    (n%02d) %10d %8.1f|(n%02d) %10d %9.1f\n", A(maxperm));
    printf("numclient  (n%02d) %10d %8.1f|(n%02d) %10d %9.1f\n", A(numclient));
    printf("maxclient  (n%02d) %10d %8.1f|(n%02d) %10d %9.1f\n", A(maxclient));
    printf("nonpinnable(n%02d) %10d %8.1f|(n%02d) %10d %9.1f\n", A(nonpinnable));
    printf("totalvmem  (n%02d) %10d %8.1f|(n%02d) %10d %9.1f Total paging space\n", A(totalvmem));
    printf("freevmem   (n%02d) %10d %8.1f|(n%02d) %10d %9.1f Free paging space\n", A(freevmem));
    printf("pageresv   (n%02d) %10d %8.1f|(n%02d) %10d %9.1f\n", A(pageresv));

    
} /* main */
