/* -- AIX/6000 System monitor 
**
**     print_ifnet.c
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-2001 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <curses.h>
#include "config.h"
#include "get_ifnet.h"
#include "print_ifnet.h"
#include "print.h"

#define min(a,b) ((a)<(b)?(a):(b))

extern int show_inet_full;
extern int show_disk_full;
extern int show_smp;
extern int show_sys_summary;
extern int ndisk;
extern int cpu_cnt;
extern int dk_cnt;

extern int numlines;

extern FILE *logfp;



/*
 * Variables to calculate rates
 */
float bytesinrate[MAX_IFNETS], bytesoutrate[MAX_IFNETS];
float packinrate[MAX_IFNETS], packoutrate[MAX_IFNETS];

/*
 * Variables for maintaining max values
 */
float bytesinrate_max[MAX_IFNETS], bytesoutrate_max[MAX_IFNETS];
float packinrate_max[MAX_IFNETS], packoutrate_max[MAX_IFNETS];

/*
 * Variables to determine screen location for network figures
 */
int net_x, net_y;

/*
 * Local function declarations
 */

/*******************************************************************
 * Functions
 *******************************************************************/

#define IFDELTA(i,a) ((if1[i]->a) - (if2[i]->a))

void
calc_ifnet(double refresh_time, struct ifnet *if1[], struct ifnet *if2[])
{
    int i;

    for (i = 0; i < if_cnt; i++) {
#if AIX_VERSION == 3 && AIX_RELEASE == 1 
	bytesinrate[i]  = IFDELTA(i, ifInOctets)  / 1024.0 / refresh_time;
	bytesoutrate[i] = IFDELTA(i, ifOutOctets) / 1024.0 / refresh_time;
#else
	bytesinrate[i]  = IFDELTA(i, if_ibytes) / 1024.0 / refresh_time;
	bytesoutrate[i] = IFDELTA(i, if_obytes) / 1024.0 / refresh_time;
#endif
	packinrate[i]  = IFDELTA(i, if_ipackets) / refresh_time;
	packoutrate[i] = IFDELTA(i, if_opackets) / refresh_time;

        SETMAX(bytesinrate[i], bytesinrate_max[i]);
        SETMAX(bytesoutrate[i], bytesoutrate_max[i]);
        SETMAX(packinrate[i], packinrate_max[i]);
        SETMAX(packoutrate[i], packoutrate_max[i]);
    }

   return;

} /* calc_ifnet */



void
print_ifnet_init()
{

    net_x = show_inet_full && show_sys_summary ? 0 : 54;
#ifdef mon_notdef
    net_y = show_inet_full && show_sys_summary ? 5 : 19;
#else
    net_y = show_inet_full && show_sys_summary ? 5 : 18;
#endif
    if (show_sys_summary && show_inet_full) {
        if (show_smp)
            net_y += (cpu_cnt + 2);
        if (show_disk_full)
            net_y += ((ndisk ? min(ndisk, dk_cnt) : dk_cnt) + 3);
                 /* account for "Active" line */
    }
#if 0
fprintf(stderr, "net_x = %d, net_y = %d ndisl = %d dk_cnt = %d\n",
    net_x, net_y, ndisk, dk_cnt);
#endif
    move(net_y, net_x); BOLDON; printw("Netw   read  write kB/s");
    if (show_inet_full && show_sys_summary)
        printw("  packin  packout insize outsize");
    BOLDOFF;

    return;

} /* print_ifnet_init */



void
print_ifnet(double refresh_time, struct ifnet *if1[], struct ifnet *if2[])
{
    int i;
    int x, y;
    int row = net_y + 1;

    for (i = 0; i < if_cnt && row < numlines; i++, row++) {
	move(net_y + 1 + i, net_x);
        if (!show_inet_full && show_sys_summary) NAMECOLON;
	printw("%3s%1d", if1[i]->if_name, if1[i]->if_unit);
        if (!show_inet_full && show_sys_summary) NAMECOLOFF;
        VALUECOLON;
	printw(" %7.1f %7.1f", bytesinrate[i], bytesoutrate[i]);
        if (show_inet_full && show_sys_summary)
            printw("    %7.1f  %7.1f %6d %6d",  packinrate[i], packoutrate[i],
                   packinrate[i]  ?
                         (int) (1024 * bytesinrate[i]  / packinrate[i])  : 0,
                   packoutrate[i] ?
                         (int) (1024 * bytesoutrate[i] / packoutrate[i]) : 0);
    }
    VALUECOLOFF;

    return;

} /* print_ifnet */



void
log_ifnet_header()
{

    fprintf(logfp, "# net[_max] name  kByte_in/second kByte_out/second "
                   "packets_in/second packets_out/second\n");

    return;

} /* log_ifnet_header */



void
log_ifnet(double refresh_time, struct ifnet *if1[], struct ifnet *if2[])
{
    int i;

    for (i = 0; i < if_cnt; i++)
	fprintf(logfp, "net %-2s%1d  %.1f %.1f %.1f %.1f\n",
                       if1[i]->if_name, if1[i]->if_unit,
                       bytesinrate[i], bytesoutrate[i],
                       packinrate[i], packoutrate[i]);

    return;

} /* log_ifnet */



void
max_ifnet_init()
{
    int i;

    for (i = 0; i < if_cnt; i++) {
        bytesinrate_max[i] = bytesoutrate_max[i] = 0.0;
        packinrate_max[i] = packoutrate_max[i] = 0.0;
    }

    return;

} /* max_ifnet_init */



void
log_ifnet_max(struct ifnet *ifn[])
{
    int i;

    /*
     * Network info
     */
    for (i = 0; ifn[i]; i++)
	fprintf(logfp, "net_max %-2s%1d  %.1f %.1f\n",
                       ifn[i]->if_name, ifn[i]->if_unit,
                       bytesinrate_max[i], bytesoutrate_max[i]);

    return;

} /* log_ifnet_max */
