/* -- AIX/6000 System monitor 
**
**     get_odm.c
**
** Copyright (c) 1993-2001 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/
/*
 * for stand alone compilation:
 * cc -o odm -lodm odm.c -DSTANDALONE
 * 
 * odm code to check AIX level
 */


#include <stdio.h>
#include <sys/types.h>
#include <cf.h>
#include <odmi.h>

/*
 * retrieved structure info using 'odmshow lpp' command
 * should dynamically determine this but...
 */
struct lpp {
        char filler[12];
	char name[145];          /* offset: 0xc ( 12) */
	long size;               /* offset: 0xa0 ( 160) */
	short state;             /* offset: 0xa4 ( 164) */
	long cp_flag;            /* offset: 0xa8 ( 168) */
	char *group;             /* [22] offset: 0xac ( 172) */
	char magic_letter[2];    /* offset: 0xb0 ( 176) */
	short ver;               /* offset: 0xb2 ( 178) */
	short rel;               /* offset: 0xb4 ( 180) */
	short mod;               /* offset: 0xb6 ( 182) */
	short fix;               /* offset: 0xb8 ( 184) */
	char *description;       /* [82] offset: 0xbc ( 188) */
	short lpp_id;            /* offset: 0xc0 ( 192) */
};

/*
 * retrieved structure info using 'odmshow product' command
 * should dynamically determine this but...
 */
struct product {
        char filler[12];
        char lpp_name[145];      /* offset: 0xc ( 12) */
        char comp_id[20];        /* offset: 0x9d ( 157) */
        short update;            /* offset: 0xb2 ( 178) */
        long cp_flag;            /* offset: 0xb4 ( 180) */
        char fesn[10];           /* offset: 0xb8 ( 184) */
        char *name;              /*[42] offset: 0xc4 ( 196) */
        short state;             /* offset: 0xc8 ( 200) */
        short ver;               /* offset: 0xca ( 202) */
        short rel;               /* offset: 0xcc ( 204) */
        short mod;               /* offset: 0xce ( 206) */
        short fix;               /* offset: 0xd0 ( 208) */
        char ptf[10];            /* offset: 0xd2 ( 210) */
        short media;             /* offset: 0xdc ( 220) */
        char sceded_by[10];      /* offset: 0xde ( 222) */
        char *fixinfo;           /* [1024] offset: 0xe8 ( 232) */
        char *prereq;            /* [1024] offset: 0xec ( 236) */
        char *description;       /* [1024] offset: 0xf0 ( 240) */
        char *supersedes;        /* [512] offset: 0xf4 ( 244) */
};



struct Class *My_CLASS;         /* customized devices class ptr */


#if defined(MAIN)
main(int argc, char *argv)
{
    int ver, rel, lev, fix;

    if (bos_level(&ver, &rel, &lev, &fix)) {
        printf("Hmm, odm failed for bos.mp, giving up\n");
        exit(1);
    }
    printf("%d.%d.%d.%d\n", ver, rel, lev, fix);
   
} /* main */
#endif



int bos_level(int *aix_version, int *aix_release, int *aix_level, int *aix_fix)
{
    struct Class *my_cl;   /* customized devices class ptr */
    struct product  productobj;     /* customized device object storage */
    int	rc, getit, found = 0;
    char *path;

    /*
     * start up odm
     */
    if (odm_initialize() == -1)
        return E_ODMINIT; 

    /*
     * Make sure we take the right database
     */
    if ((path = odm_set_path("/usr/lib/objrepos")) == (char *) -1)
        return odmerrno;
 
    /*
     * Mount the lpp class
     */
    if ((My_CLASS = odm_mount_class("product")) == (CLASS_SYMBOL) -1)
        return odmerrno;

    /*
     * open customized devices object class
     */
    if ((int)(my_cl = odm_open_class(My_CLASS)) == -1)
        return E_ODMOPEN;

    /*
     * Loop trough all entries for the lpp name, ASSUMING the last
     * one denotes the up to date number!!!
     */
    /*
     * AIX > 4.2 uses bos.mp or bos.up
     */
    getit = ODM_FIRST;
    while ((rc = (int)odm_get_obj(my_cl, "name like bos.?p",
                                  &productobj, getit)) != 0) {
        getit = ODM_NEXT;
        if (rc == -1) {
            /* ODM failure */
            break;
        }
        else {
            *aix_version = productobj.ver;
            *aix_release = productobj.rel;
            *aix_level   = productobj.mod;
            *aix_fix     = productobj.fix;
            found++;
        }
    }
    /*
     * AIX < 4.2 uses bos.mp or bos.up
     */
    if (!found) {
        getit = ODM_FIRST;
        while ((rc = (int)odm_get_obj(my_cl, "name like bos.rte.?p",
                                      &productobj, getit)) != 0) {
            getit = ODM_NEXT;
            if (rc == -1) {
                /* ODM failure */
                break;
            }
            else {
                *aix_version = productobj.ver;
                *aix_release = productobj.rel;
                *aix_level   = productobj.mod;
                *aix_fix     = productobj.fix;
                found++;
            }
        }
    }



    /*
     * close lpp object class
     */
    odm_close_class(my_cl);

    odm_terminate();

    free(path);
    return (found ? 0 : -1);

} /* bos_level */


