#!/bin/sh
## -- AIX/6000 System monitor"
##
## check_config.sh
##
## Copyright (c) 1993-2001 Marcel Mol, All Rights Reserved.
## NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
## THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
## COPYRIGHTS.
##
#
# Script to check how we should interface with the NFS
# statistics. This is called by the Makefile to set
# some variables.
#
#
# Marcel Mol, marcel@mesa.nl
#


echo "/* -- AIX/6000 System monitor"
echo "**"
echo "**     config.h"
echo "**"
echo "** Copyright (c) 1993-2001 Marcel Mol, All Rights Reserved."
echo "** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE"
echo "** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL"
echo "** COPYRIGHTS."
echo "*/"
echo
echo "/* AUTOMATICLLY GENERATED by $0 */"
echo


osl=`./get_odm`
AIX_VERSION=`echo $osl | cut -d. -f1`
AIX_RELEASE=`echo $osl | cut -d. -f2`
AIX_LEVEL=`echo $osl | cut -d. -f3`
AIX_FIX=`echo $osl | cut -d. -f4`
echo "#define AIX_VERSION $AIX_VERSION"
echo "#define AIX_RELEASE $AIX_RELEASE"
echo "#define AIX_LEVEL $AIX_LEVEL"
echo "#define AIX_FIX $AIX_FIX"
#
# Don't add leading zeros to first part of AIX_NUM as some compilers
# assume that is an octal number...
#
echo "#define AIX_NUM `printf "%d%02d%02d%02d" $AIX_VERSION $AIX_RELEASE $AIX_LEVEL $AIX_FIX`"

#
# AIX 2 and 3 use old interface
# and nfs_cntl is not available
#
if [ "$AIX_VERSION" -lt 4 ] ; then
   echo "#define USE_NFS_CNTL 0"
   exit 0
fi

if [[ "$AIX_VERSION" -eq 4  && $AIX_RELEASE -eq 1 ]] ; then
   #
   # AIX 4.1 seems to have nfs_cntl and /usr/include/nfs
   # but when linking monitor it complains about nfs_cntl.
   # The 'old' way still ssems to work...
   echo "#define USE_NFS_CNTL 0"
   exit 0
fi


#
# We are AIX version 4 and higher
#
if [ ! -f /usr/lib/drivers/nfs.ext ] ; then
    #
    # probably not AIX 4.3 and higher
    #
    if [ ! -f /usr/lib/drivers/nfs_clnt.ext ] ; then
        #
        # NFS lpp is not installed
        # or this system does not use nfs_cntl interface
        #
        echo "#define USE_NFS_CNTL 0"
        exit 0
    fi
fi    

# 
# We have the kernel extension, now
# check if we have the include files...
#
if [ -d /usr/include/nfs ] ; then
    echo "#define USE_NFS_CNTL 1"
    exit 0
fi

#
# Hmm, we have NFS, but the include files
# are not there...
echo "#define USE_NFS_CNTL 0"
exit 0


#
# The end
#
